/*(C)2012-2014 Busmatick Group <www.busmatick.com>*/
var map;
var infoWindow = new google.maps.InfoWindow({});
var markersArray=[];
var labelsArray=[];
var BtkTrackingInterval=30000;
var BtkTrackingFile="btktracking.xml";
var MarkAncho=40;
var MarkAlto=40;

function BtkTrackingInit(Lat,Lon,MapZoom,Interval){
	var InitPos = new google.maps.LatLng(Lat,Lon);
	var InitOptions = {zoom:MapZoom, center: InitPos, mapTypeId: google.maps.MapTypeId.ROADMAP}
	map = new google.maps.Map(document.getElementById("map_canvas"), InitOptions);
	BtkTrackingInterval = Interval * 1000;
	if (BtkTrackingInterval<5000) BtkTrackingInterval=5000;
	RefreshMarkers();
}

function Label(opt_options) {
	opt_options.labelcaption = opt_options.labelcaption || "";
	this.setValues(opt_options);
	var span = this.span_ = document.createElement('span');
	span.style.cssText = 'position: relative; left: 9.0px; top: -25.0px; white-space: nowrap; border: 0px; padding: 2px';
	var div = this.div_ = document.createElement('div');
	div.appendChild(span);
	div.style.cssText = 'position: absolute; display: none';
	span.className = opt_options.labelstyle;
	span.innerHTML = opt_options.labelcaption;
	this.bindTo('position', opt_options.marker, 'position');
	this.bindTo('text', opt_options.marker, 'position');
};

Label.prototype = new google.maps.OverlayView;

Label.prototype.onAdd = function() {
	var pane = this.getPanes().overlayLayer;
	pane.appendChild(this.div_);
};

Label.prototype.onRemove = function() {
	this.div_.parentNode.removeChild(this.div_);
};

Label.prototype.draw = function() {
	var projection = this.getProjection();
	var position = projection.fromLatLngToDivPixel(this.get('position'));
	var div = this.div_;
	div.style.left = position.x + 'px';
	div.style.top = position.y + 'px';
	div.style.display = 'block';
};

function RefreshMarkers(){
	try{BtkLoadMarkers();}finally{setTimeout("RefreshMarkers()", BtkTrackingInterval);}
}

function BtkLoadMarkers(){
	try{
		var xmlDoc;
		if (window.XMLHttpRequest){
			var xmlreq = new window.XMLHttpRequest();
    	xmlreq.open("GET", BtkTrackingFile+"?noCache="+new Date().valueOf(), false);
			xmlreq.setRequestHeader("Content-Type","text/xml");
    	xmlreq.send("");
    	xmlDoc = xmlreq.responseXML;
 		}else if (ActiveXObject("Microsoft.XMLDOM")){
    	xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
    	xmlDoc.async = false;
    	xmlDoc.load(BtkTrackingFile+"?noCache="+new Date().valueOf());
 		}
		if (!xmlDoc) return;
		var i,cap,tit,est,ico;
		var isize = new google.maps.Size(MarkAncho,MarkAlto);
		var iorigin = new google.maps.Point(0,0);
		var ianchor = new google.maps.Point(MarkAncho/2,MarkAlto/2);
 		var markers_tag = xmlDoc.getElementsByTagName("list")[0].getElementsByTagName("marker");
		infoWindow.close();
  	if (markersArray){
    	for (i in markersArray) markersArray[i].setMap(null);
    	markersArray.length=0;
  	}
  	if (labelsArray){
    	for (i in labelsArray) labelsArray[i].setMap(null);
    	labelsArray.length=0;  		
  	}
	 	for (i=0; i<markers_tag.length; i++){
 			var loc = new google.maps.LatLng(markers_tag[i].getElementsByTagName("lat")[0].childNodes[0].nodeValue, markers_tag[i].getElementsByTagName("lon")[0].childNodes[0].nodeValue);
 			cap = markers_tag[i].getElementsByTagName("cap")[0].childNodes[0].nodeValue;
 			tit = markers_tag[i].getElementsByTagName("tit")[0].childNodes[0].nodeValue;
 			est = "label_" + markers_tag[i].getElementsByTagName("est")[0].childNodes[0].nodeValue;
 			ico = new google.maps.MarkerImage(markers_tag[i].getElementsByTagName("ico")[0].childNodes[0].nodeValue+".png",isize,iorigin,ianchor);
 			var marker=new google.maps.Marker({position:loc, map:map, icon:ico});
 			marker.set('infotext',cap);
 			marker.set('title',cap.replace(/[{}]/g,""));
			google.maps.event.addListener(marker, "click", function(event){
         infoWindow.setContent("<span class=infowindow>"+this.infotext.replace(/{/g,"<span class=infocaption>").replace(/}/g,"</span>").replace(/,/g,"<br>")+"</span>");
         infoWindow.open(map, this);
      });
  		markersArray.push(marker);
  		if (tit){
	  		var label = new Label({map:map, marker:marker, labelcaption:tit, labelstyle:est});
  			labelsArray.push(label);
  		}
		}
	}catch(Exception){}
}
