/*******************************************************************/
/****  BUSMATICK OFFICE  2.10                                   ****/
/****  Seguimiento de flota mediante Google Maps API v 3        ****/
/****  (C)2012-2013 Busmatick Group <http://www.busmatick.com/> ****/
/****  Autor: Pablo Alebizakis <pablo.alebizakis@busmatick.com> ****/
/*******************************************************************/
var map;
var monmarker;
var monresalt;
var MarkAncho=40;
var MarkAlto=40;

//Funcin para crear el mapa la primera vez solamente
function BtkMonitorInit(MapZoom, Lat, Lon, Icono, Tit, Resalt){
	var InitPos = new google.maps.LatLng(Lat,Lon);
	var InitOptions = {zoom:MapZoom, center: InitPos, mapTypeId: google.maps.MapTypeId.ROADMAP}
	map = new google.maps.Map(document.getElementById("map_canvas"), InitOptions);
	monmarker=new google.maps.Marker({position:InitPos, map:map});
	monresalt=new google.maps.Circle({strokeColor: "#FF0000", strokeOpacity: 0.5, strokeWeight: 3, fillColor:"#808080", fillOpacity: 0.35, map: map, radius: 90, visible:false, editable:false});
	BtkMonitorUpdate(Lat,Lon,Icono,Tit,Resalt);
}

//Funcin para actualizar la posicin del marcador en el mapa, llamada desde BtkMonitor
function BtkMonitorUpdate(Lat, Lon, Icono, Tit, Resalt){
	try{
		var i,ico;
		var isize = new google.maps.Size(MarkAncho,MarkAlto);
		var iorigin = new google.maps.Point(0,0);
		var ianchor = new google.maps.Point(MarkAncho/2,MarkAlto/2);
		var loc = new google.maps.LatLng(Lat,Lon);
		ico = new google.maps.MarkerImage("http://intranet.cevesa.es/loc_buses/"+Icono+".png",isize,iorigin,ianchor);
		monmarker.setPosition(loc);
		monmarker.setIcon(ico);
		monmarker.setTitle(Tit);
		map.panTo(loc);
		if (Resalt){
			monresalt.setCenter(loc);
			monresalt.setVisible(true);
		}else{
			monresalt.setVisible(false);
		}
	}catch(Exception){}
}