/*(C)2012-2016 Pablo Alebizakis, Busmatick Group <www.busmatick.com>*/
var map;
var markersArray=[];
var labelsArray=[];
var BtkTrackingInterval=30000;
var BtkTrackingFile="btktracking.xml";
var MarkAncho=40;
var MarkAlto=40;
var layer01=L.tileLayer('http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',{attribution:'&copy; Colaboradores de <a target="_blank" href="http://openstreetmap.org">OpenStreetMap</a>',maxZoom:18});
var layer02=L.tileLayer('http://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}', {attribution:'&copy; <a target="_blank" href="http://www.arcgis.com">Esri</a>'});
var layer03=L.tileLayer('http://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}', {attribution:'&copy; <a target="_blank" href="http://www.arcgis.com">Esri</a>'});
var baseLayers={"OpenStreetMap":layer01, "ArcGIS":layer02, "ArcGIS satelite":layer03};

function BtkTrackingInit(Lat,Lon,MapZoom,Interval){
	try{		
		map = L.map('map_canvas').setView([Lat,Lon],MapZoom);
		map.attributionControl.setPrefix('');
		map.addLayer(layer01);
		L.control.layers(baseLayers).addTo(map);
	  L.control.scale({metric: true, imperial: false}).addTo(map);
		BtkTrackingInterval = Interval * 1000;
		if (BtkTrackingInterval<5000) BtkTrackingInterval=5000;
		RefreshMarkers();
	}catch(Exception){}
}

function RefreshMarkers(){
	try{BtkLoadMarkers();}finally{setTimeout("RefreshMarkers()", BtkTrackingInterval);}
}

function BtkLoadMarkers(){
	try{
		var xmlDoc;
		if (window.XMLHttpRequest){
			var xmlreq = new window.XMLHttpRequest();
    	xmlreq.open("GET", BtkTrackingFile+"?noCache="+new Date().valueOf(), false);
			xmlreq.setRequestHeader("Content-Type","text/xml");
    	xmlreq.send("");
    	xmlDoc = xmlreq.responseXML;
 		}else if (ActiveXObject("Microsoft.XMLDOM")){
    	xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
    	xmlDoc.async = false;
    	xmlDoc.load(BtkTrackingFile+"?noCache="+new Date().valueOf());
 		}
		if (!xmlDoc) return;
		var i,cap,tit,est,ico;
 		var markers_tag = xmlDoc.getElementsByTagName("list")[0].getElementsByTagName("marker");
		
  	if (markersArray){
    	for (i in markersArray) map.removeLayer(markersArray[i]);
    	markersArray.length=0;
  	}
  	if (labelsArray){
    	for (i in labelsArray) map.removeLayer(labelsArray[i]);
    	labelsArray.length=0;  		
  	}
	 	for (i=0; i<markers_tag.length; i++){
			var loc = new L.LatLng(markers_tag[i].getElementsByTagName("lat")[0].childNodes[0].nodeValue, markers_tag[i].getElementsByTagName("lon")[0].childNodes[0].nodeValue, true);
			cap = markers_tag[i].getElementsByTagName("cap")[0].childNodes[0].nodeValue;
 			tit = markers_tag[i].getElementsByTagName("tit")[0].childNodes[0].nodeValue;
 			est = "label_" + markers_tag[i].getElementsByTagName("est")[0].childNodes[0].nodeValue;
 			ico = new L.icon({iconUrl:markers_tag[i].getElementsByTagName("ico")[0].childNodes[0].nodeValue+".png", iconRetinaUrl:markers_tag[i].getElementsByTagName("ico")[0].childNodes[0].nodeValue+".png",iconSize:[MarkAncho, MarkAlto],iconAnchor:[MarkAncho/2, MarkAlto/2]});
			var marker = new L.Marker(loc,{icon:ico,draggable:false,title:cap.replace(/[{}]/g,""),alt:tit,zIndexOffset:0,opacity:1});
			map.addLayer(marker);
			marker.bindPopup("<span class=infowindow>"+cap.replace(/{/g,"<span class=infocaption>").replace(/}/g,"</span>").replace(/,/g,"<br>")+"</span>"); 			
  		markersArray.push(marker);
  		if (tit){
	  		ico = new L.divIcon({className:est,iconAnchor:[MarkAncho/4,MarkAlto*3/4],iconSize:[1,1],html:tit});
	  		var label = new L.Marker(loc,{icon:ico,clickable:false,draggable:false,title:'',alt:'',zIndexOffset:1,opacity:1});	  		
  			map.addLayer(label);
  			labelsArray.push(label);
  		}
		}
	}catch(Exception){}
}
