<?php

function certsex($form, &$form_state){
  global $user;
  global $base_path;
  $id_empleado = $user->uid;
  $name_empleado = $user->name;
  $u_admin = FALSE;
  $form = array();

  if (in_array('AdminEmpleados',$user->roles) || in_array('administrator',$user->roles)) $u_admin = TRUE;
  if (isset($_GET['empleado'])){
    if (!$u_empleado = user_load($_GET['empleado'])){
      drupal_set_message(t('Error en selección de Empleado.'),'error');
    }else{
      /*if (in_array('AdminEmpleados',$u_empleado->roles) && $user->uid != $u_empleado->uid){
        drupal_set_message(t('Empleado Seleccionado está Bloqueado, es Administrador'),'error');
      }else*/if (!$u_admin && $user->uid != $u_empleado->uid){
        //drupal_set_message(t('Sin acceso a otros usuarios.'),'error');
        $u_empleado = user_load($user->uid);
      }else{
        $id_empleado = $u_empleado->uid;
      }
    }
  }

  $empleado = obtenernombre($u_empleado->uid);
  $name_empleado = $empleado['usuario'];

  $menu = '<li><a href="'.$base_path.'empleados?empleado='.$id_empleado.'">Datos Personales</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/foto?empleado='.$id_empleado.'">Foto</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/dni?empleado='.$id_empleado.'">DNI</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/naf?empleado='.$id_empleado.'">Tarjeta SS</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/pconducir?empleado='.$id_empleado.'">Permiso de Conducir</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/tach?empleado='.$id_empleado.'">Tarjeta Tacógrafo</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/cap?empleado='.$id_empleado.'">CAP</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/certpuntos?empleado='.$id_empleado.'">Certificado de Puntos</a></li>';
  $menu .='<li><a href="#">Certificado Delitos Sexuales</a></li>';
  $menu .='<li><b><a href="'.$base_path.'empleados/avisos?empleado='.$id_empleado.'&sort=desc&order=ENVIADO">AVISOS</a></b></li>';
  if (in_array('administrator',$user->roles))
    $menu .='<li><b><a href="'.$base_path.'empleados/config">CONFIG</a></b></li>';

  $form['menudocumentos'] = array(
    '#type' => 'item',
    '#markup' => '<ul class="tabs secondary clearfix">'.$menu.'</ul>',
    '#weight' => -50,
  );

  $form['datos'] = array(
    '#type' => 'fieldset',
    '#title' => 'Actualizar Certificado de Delitos Sexuales',
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );


  $form['datos']['id'] = array(
    '#type' => 'hidden',
    //'#markup' =>$id_empleado,
    '#value' => $id_empleado,
  );
  $form['datos']['name'] = array(
    '#type' => 'item',
    //'#markup' =>$id_empleado,
    '#markup' => 'Usuario: <b>'.$name_empleado.'</b>',
  );

  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 
	
	// iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
	
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
	ftp_pasv($conn_id, TRUE);
	$ficheros = ftp_nlist($conn_id, '');

  $fotoftp = $id_empleado.'_certsex.pdf';
  if (in_array($fotoftp,$ficheros)){
	  $form['datos']['des_cert'] = array(
	    '#type' => 'submit',
	    '#value' => 'Descargar Certificado Delitos Sexuales',
	    //'#attributes' => array('onclick' => 'if(!confirm("Seguro de borrar el coche seleccionado?")){return false;}'),
	    '#submit' => array('descargarcertsex'),
	    //'#validate' => array('borra_coche_validate'),
	  );
  }else{  
    $form['datos']['foto'] = array(
      '#type' => 'item',
      '#markup'=> '<i>No existe fichero actualmente.</i>',
    );
    
  }
  ftp_close($conn_id);

  $form['datos']['file'] = array(
        '#type' => 'file',
        '#title' => t('Fichero:'),
        '#description' => 'Seleccione Fichero.<br />Sólo se permiten formatos "<strong>.pdf</strong>"',
  );

  $query = db_select('empleados_doc','d')
    ->fields('d',array('certsex_actualiza','certsex_fecha_exp','certsex_uid_actualiza'))
    ->condition('eid',$id_empleado);
  $result = $query->execute();
  $exp = NULL;
  $actualiza = NULL;
  $u_actualiza = 0;
  foreach ($result as $q){
    $exp = $q->certsex_fecha_exp;
    $actualiza = $q->certsex_actualiza;
    $u_actualiza = $q->certsex_uid_actualiza;
  }
  $format = 'd-m-Y';
  $form['datos']['fecha'] = array(
    '#type' => 'date_popup',
    '#title' => t('Fecha Expedición Certificado'),
    '#default_value' => $exp, 
    '#date_format' => $format,
    '#size' => 12,
    '#date_label_position' => 'within',
    '#date_year_range' => '-20:+20',
    '#attributes'=> array('autocomplete' => 'off'),
  );

  if (isset($actualiza)){
    $form['datos']['ult_actualiza'] = array(
      '#type' => 'item',
      '#markup' =>'<p>Última actualización: <b>'.date('d-m-Y',strtotime($actualiza)).'</b></p>',
    );
  }

  $form['datos']['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Guardar Datos'),
    '#validate' => array('certsex_val'),
    '#submit' => array('certsex_sub')
  );
  return $form;
}

function certsex_val($form, &$form_state){
  $file = file_save_upload('file', array(
    'file_validate_extensions' => array('pdf'),
  ));
  if ($file) {
    if ($file = file_move($file, 'public://docs/up')) {
      $form_state['values']['file'] = $file;
    }
    else {
      form_set_error('file', t('Fallo al escribir el fichero en la carpeta site\'s.'));
    }
  }
  else {
    form_set_error('file', t('Fichero no actualizado.'));
  }
  $valores = explode('-',$form_state['values']['fecha']);
  if(count($valores) != 3 || !checkdate($valores[1], $valores[2], $valores[0]))
    form_set_error('fecha',t('Campo <strong>Fecha Expedición</strong> incorrecta.'));
  $id_empleado = $form_state['values']['id'];
  $query = db_select('empleados_doc','e')
    ->fields('e', array('certsex_fecha_exp'))
    ->condition('eid',$id_empleado);
  $result = $query->execute();

  if ($result->rowCount() > 0){
    foreach($result as $r){
      $fecha = $r->certsex_fecha_exp;
    }
    if(strtotime($fecha) > strtotime($form_state['values']['fecha'])){
      form_set_error('fecha',t('La <strong>Fecha Expedición</strong> es inferior a la fecha anterior.'));
    }
  }
}

function certsex_sub($form, &$form_state){
  global $user;
  $file=$form_state['values']['file'];
  unset($form_state['values']['file']);
  $file->status = FILE_STATUS_PERMANENT;
  file_save($file);
  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 
	
	// iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
	
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
  ftp_pasv($conn_id,TRUE);
  $fotoftp = $form_state['values']['id'].'_certsex.pdf';
  ftp_put($conn_id, $fotoftp, $file->uri, FTP_BINARY);
  ftp_close($conn_id);

  $query = db_delete('file_managed')
    ->condition('uid',$user->uid)
    ->condition('filename',$file->filename)
    ->condition('status',1)
    ->execute();
  drupal_set_message(t('Fichero actualizado correctamente.'));

  $id_empleado = $form_state['values']['id'];
  $query = db_select('empleados_doc','e')
    ->fields('e', array('certsex_actualiza'))
    ->condition('eid',$id_empleado);
  $result = $query->execute();
  if ($result->rowCount() > 0){
    $query = db_update('empleados_doc')
      ->fields(array(
        'certsex_fecha_exp' => date('Y-m-d',strtotime($form_state['values']['fecha'])),
        'certsex_uid_actualiza' => $user->uid,
        'certsex_actualiza' => date('Y-m-d'),
      ))
      ->condition('eid',$id_empleado)
    ->execute();
  }else{
    $query = db_insert('empleados_doc')
      ->fields(array(
        'eid' => $id_empleado,
        'certsex_fecha_exp' => date('Y-m-d',strtotime($form_state['values']['fecha'])),
        'certsex_uid_actualiza' => $user->uid,
        'certsex_actualiza' => date('Y-m-d'),
       ))
    ->execute();
  }

  $query = db_select('empleados_config','e')
  ->fields('e',array('mail_certsex'));
  $result=$query->execute();
  foreach($result as $r){
    $to = $r->mail_certsex;
  }
  $mailto = str_replace(' ','',$to);
  $module = 'empleados';
  $key = 'certsex_actualizado';
  $from = NULL;
  $language = language_default();
  $params = array(
    'fichero' => $file->filename,
    'eid' => $id_empleado,
    'fecha' => date('d-m-Y',strtotime($form_state['values']['fecha'])),
  );
  $send = TRUE;
  $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
  if($result){
    drupal_set_message(t('Se ha enviado un aviso al administrador para hacer efectivo el cambio.'));
  }else{
    drupal_set_message(t('Error al avisar al administrador del cambio del Certificado de Delitos Sexuales.'),'error');
  }

  unlink($file->uri);
}

Function descargarcertsex($form, &$form_state){
  global $user;
  $id_empleado = $form_state['values']['id'];
  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 
	
	// iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
  
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
  ftp_pasv($conn_id, TRUE);


  $fftp = $id_empleado.'_certsex.pdf';
  $f_local = $user->uid.substr(str_shuffle("-_0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 10).$id_empleado.'.pdf';
  $url_local = getcwd().'/sites/default/files/docs/'.$f_local;
  ftp_get($conn_id, $url_local, $fftp, FTP_BINARY);
 
  ftp_close($conn_id);



  $size = filesize($url_local);
	
  header('Content-type: application/pdf');
  header("Content-Disposition: inline; filename=CertSex.pdf");
  //header('Content-Disposition: attachment; filename="'.$falsa_url_pdf.'"');	
  //header("Content-Transfer-Encoding: binary");
  //header("Content-Length: " . $size);
  //header("Accept-Ranges: bytes");

  readfile($url_local);
  unlink($url_local);
  exit();
}